﻿var m_JSON_REPLACE = [];//替换缓存
var m_JSON_REMOVE = [];//过滤缓存
var m_Coordinate = -1;//用于存储修改时替换敏感词的下标 
var m_FilterWords = -1;//存储修改时过滤敏感词下标
$(function () {
    $("#myPageAlert").hide();//错误提示框
    $("#repalceBox").show();//替换框隐藏
    $("#filterBox").hide();//过滤框隐藏
    $(".loading").show();
    $(".loadingcover").show();
    manageObj.getsensitivwords();
});

//显示(替换或过滤)单击事件
function AlternateFiltering(type) {

    if (type == 1) {
        $("#replaceRdo").prop("checked", true);//设置替换按键状态
        $("#filterRdo").prop("checked", false); //设置过滤按键状态
        $("#repalceBox").show();//替换框
        $("#filterBox").hide();//过滤框
        $("#replaceBtn").text("添加");//替换的添加按钮
        $("#replacefront").val("");
        $("#replaceafter").val("");
        $("#replaceCancelBtn").attr("style", "display:none");
        m_FilterWords = -1;//选择替换敏感词时将过滤下标清空
    } else {
        $("#replaceRdo").prop("checked", false);//设置替换按键状态
        $("#filterRdo").prop("checked", true); //设置过滤按键状态
        $("#repalceBox").hide();//替换框
        $("#filterBox").show();//过滤框
        $("#filterBtn").text("添加");//过滤的添加按钮
        $("#filter").val("");
        $("#filterCanceBtn").attr("style", "display:none");
        m_Coordinate = -1;//选择过滤铭感词时将替换下标清空
    }
}

//初始敏感词替换过滤遍历
function AsyncGetSensitivWords(jsonResult) {
    $(".loading").hide();
    $(".loadingcover").hide();
    if (jsonResult.keywords) {//兼容版本
        if (jsonResult.keywords.length == 0 || ($.parseJSON(jsonResult.keywords[0].valus).replace.length == 0 && $.parseJSON(jsonResult.keywords[0].valus).remove == 0)) {
            $("#ulContainer").html("暂无数据!");
            return;
        }
        m_JSON_REPLACE = $.parseJSON(jsonResult.keywords[0].valus).replace;
        m_JSON_REMOVE = $.parseJSON(jsonResult.keywords[0].valus).remove;
        ArrayTraversal();//加载页面调用
    }
    else {
        $("#ulContainer").html("暂无数据!");
    }
    DeleteBtn();//按钮样式调用
}

//重新加载页面
function ArrayTraversal() {
    var strContent = "";//向ul中添加元素
    for (i in m_JSON_REPLACE) {
        strContent += "<li class=\"sensitive-box\" style=\"cursor:pointer\" onclick=\"Selected(" + "1" + "," + i + ");\">";
        strContent += "<span class=\"label label-success\">换</span>";
        strContent += "<span id=\"BeforeSubstitution" + i + "\">" + m_JSON_REPLACE[i].replacefront + "</span>";
        strContent += "<i class=\"fa fa-arrow-right\" aria-hidden=\"true\"></i>";
        strContent += "<span id=\"afterReplacement" + i + "\">" + m_JSON_REPLACE[i].replaceafter + "</span>";
        strContent += "<i class=\"fa fa-times i-close\" aria-hidden=\"true\" onclick=\"DeleteElement(" + "event,1," + i + ");\"></i>";
        strContent += "</li>";
    }
    for (j in m_JSON_REMOVE) {
        strContent += "<li class=\"sensitive-box\" style=\"cursor:pointer\" onclick=\"Selected(" + "2" + "," + j + ");\">";
        strContent += " <span class=\"label label-default\">删</span>";
        strContent += "<span id=\"filterWords" + j + "\">" + m_JSON_REMOVE[j].filter + "</span>";
        strContent += "<i class=\"fa fa-times i-close\" aria-hidden=\"true\" onclick=\"DeleteElement(" + "event,2," + j + ");\"></i>";
        strContent += "</li>";
    }
    $("#ulContainer").html(strContent);
    DeleteBtn();//按钮样式调用
}
//添加,修改
function AddModify(type) {
    if (m_JSON_REPLACE.length + m_JSON_REMOVE.length > 100) {
        ShowMsg("myPageAlert", "已达到敏感词上限！");
        return;
    }
    //替换敏感词input过滤敏感词
    var filter = $("#filter");
    var replacefront = $("#replacefront");
    var replaceafter = $("#replaceafter");
    if (type == 1) {
        if ($.trim(Canceller(replacefront.val())) == "") {
            replacefront.val("");
            ShowMsg("myPageAlert", "请填写需要变换的敏感词！");
            replacefront.focus();
            return;
        }
        if ($.trim(Canceller(replaceafter.val())) == "") {
            replaceafter.val("");
            ShowMsg("myPageAlert", "请填写变换后的敏感词！");
            replaceafter.focus();
            return;
        }
        if ($.trim(Canceller(replacefront.val())) == $.trim(Canceller(replaceafter.val()))) {
            ShowMsg("myPageAlert", "关键词替换不能相同！");
            replaceafter.focus();
            return;
        }
        if ($("#replaceBtn").text() == "修改") {
            if (!Check($.trim(Canceller(replacefront.val())), $.trim(Canceller(replaceafter.val())))) {
                ShowMsg("myPageAlert", "已存在该敏感词!");
                return;
            }
            var json = ({
                replacefront: $.trim(Canceller(replacefront.val())),
                replaceafter: $.trim(Canceller(replaceafter.val()))
            });
            m_JSON_REPLACE[m_Coordinate] = json;
            ArrayTraversal();
        } else {
            if ($.trim(Canceller(replacefront.val())) == "") {
                replacefront.val("");
                ShowMsg("myPageAlert", "请填写要修改的敏感词！");
                replacefront.focus();
                return;
            }
            if ($.trim(Canceller(replaceafter.val())) == "") {
                replaceafter.val("");
                ShowMsg("myPageAlert", "请填写变换后的敏感词！");
                replaceafter.focus();
                return;
            }
            if (!Check($.trim(Canceller(replacefront.val())), $.trim(Canceller(replaceafter.val())))) {
                ShowMsg("myPageAlert", "已存在该敏感词!");
                return;
            }
            var json = ({
                replacefront: $.trim(Canceller(replacefront.val())),
                replaceafter: $.trim(Canceller(replaceafter.val()))
            });
            m_JSON_REPLACE.push(json);
            ArrayTraversal();
        }
        $("#replacefront").val("");
        $("#replaceafter").val("");
        $("#replaceCancelBtn").attr("style", "display:none");
    } else {
        if ($.trim(Canceller(filter.val())) == "") {
            filter.val("");
            ShowMsg("myPageAlert", "请填写要过滤的敏感词！");
            filter.focus();
            return;
        }
        if (!CheckRemove($.trim(Canceller(filter.val())))) {
            ShowMsg("myPageAlert", "已存在该敏感词!");
            return;
        }
        if ($("#filterBtn").text() == "修改") {
            var json = ({
                filter: $.trim(Canceller(filter.val())),
            });
            m_JSON_REMOVE[m_FilterWords] = json;
            ArrayTraversal();
        } else {
            var json = ({
                filter: $.trim(Canceller(filter.val())),
            });
            m_JSON_REMOVE.push(json);
            ArrayTraversal();
        }
        $("#filter").val("");
        $("#filterCanceBtn").attr("style", "display:none");
    }
    $("#replaceBtn").text("添加");
    $("#filterBtn").text("添加");
    m_Coordinate = -1;
    m_FilterWords = -1;
}

//替换关键字查重
function Check(replce, replceval) {
    var Bisreplace = true;
    var Bisdel = true;
    //修改的情况下
    if (m_Coordinate != -1) {
        //修改时
        for (i in m_JSON_REPLACE) {
            //修改替换敏感词的四种情况
            if (replce == $("#BeforeSubstitution" + m_Coordinate).text() && replceval == $("#afterReplacement" + m_Coordinate).text()) {
                Bisreplace = true;
            }
            else if (replce != $("#BeforeSubstitution" + m_Coordinate).text() && replceval == $("#afterReplacement" + m_Coordinate).text()) {
                if (m_JSON_REPLACE[i].replacefront == replce || m_JSON_REPLACE[i].replaceafter == replce) {
                    Bisreplace = false;
                }
            }
            else if (replce == $("#BeforeSubstitution" + m_Coordinate).text() && replceval != $("#afterReplacement" + m_Coordinate).text()) {
                if (m_JSON_REPLACE[i].replacefront == replceval) {
                    Bisreplace = false;
                }
            }
            else {
                if (m_JSON_REPLACE[i] != m_JSON_REPLACE[m_Coordinate]) {
                    if (m_JSON_REPLACE[i].replacefront == replce || m_JSON_REPLACE[i].replaceafter == replce || m_JSON_REPLACE[i].replacefront == replceval) {
                        Bisreplace = false;
                    }
                }
            }
        }
        for (var k = 0; k < m_JSON_REMOVE.length; k++) {
            if (m_JSON_REMOVE[k].filter == replceval || m_JSON_REMOVE[k].filter == replce) {
                Bisdel = false;
            }
        }
    } else {
        //添加时
        for (i in m_JSON_REPLACE) {
            //新建的关键字替换不能与之前的关键字替换相等
            if (m_JSON_REPLACE[i].replacefront == replce || m_JSON_REPLACE[i].replacefront == replce || m_JSON_REPLACE[i].replaceafter == replce || m_JSON_REPLACE[i].replacefront == replceval) {
                Bisreplace = false;
            }
        }
        for (var k = 0; k < m_JSON_REMOVE.length; k++) {
            if (m_JSON_REMOVE[k].filter == replceval || m_JSON_REMOVE[k].filter == replce) {
                Bisdel = false;
            }
        }
    }
    //alert(Bisreplace + "------" + Bisdel);
    if (Bisreplace && Bisdel) {
        return true;
    } else {
        return false;
    }
}

//过滤关键字查重
function CheckRemove(rem) {
    if (rem == $.trim($("#filterWords" + m_FilterWords).text())) {
        return true;
    }
    for (i in m_JSON_REPLACE) {
        if (rem == m_JSON_REPLACE[i].replacefront || rem == m_JSON_REPLACE[i].replaceafter) {
            return false;
        }
        for (j in m_JSON_REMOVE) {
            if (rem == m_JSON_REMOVE[j].filter) {
                return false;
            }
        }
    }
    return true;
}
//在页面中点击选中任意一个替换敏感词或过滤敏感词
function Selected(index, type) {

    if (index == 1) {
        m_Coordinate = type;//第三变量得到下标
        m_FilterWords = -1;
        $("#replaceRdo").prop("checked", true);//设置替换按键状态
        $("#filterRdo").prop("checked", false); //设置过滤按键状态
        $("#repalceBox").show();//替换框
        $("#filterBox").hide();//过滤框
        $("#replacefront").val("");
        $("#replaceafter").val("");
        $("#replaceBtn").text("修改");
        $("#replacefront").val($("#BeforeSubstitution" + type).text());
        $("#replaceafter").val($("#afterReplacement" + type).text());
        $("#replaceCancelBtn").attr("style", "display:block");
    } else {
        m_FilterWords = type;//第三变量得到下标
        m_Coordinate = -1;
        $("#replaceRdo").prop("checked", false);//设置替换按键状态
        $("#filterRdo").prop("checked", true); //设置过滤按键状态
        $("#repalceBox").hide();//替换框
        $("#filterBox").show();//过滤框
        $("#filter").val("");
        $("#filterBtn").text("修改");
        $("#filter").val($("#filterWords" + type).text());
        $("#filterCanceBtn").attr("style", "display:block");
    }
}
//删除单击事件
//event.stopPropagation();
function DeleteElement(event, index, type) {

    event.stopPropagation();//阻止事件默认行为
    if (index == 1) {
        if (m_Coordinate > type) {
            m_Coordinate--;
        } else if (m_Coordinate == type) {
            $("#replacefront").val("");
            $("#replaceafter").val("");
            $("#filterBtn").text("添加");
            $("#replaceCancelBtn").attr("style", "display:none");
            $("#replaceBtn").text("添加");
            $("#filter").val("");
            $("#filterCanceBtn").attr("style", "display:none");
        }
        m_JSON_REPLACE.splice(type, 1);
    } else {
        if (m_FilterWords > type) {
            m_FilterWords--;
        } else if (m_FilterWords == type) {
            $("#replacefront").val("");
            $("#replaceafter").val("");
            $("#filterBtn").text("添加");
            $("#replaceCancelBtn").attr("style", "display:none");
            $("#replaceBtn").text("添加");
            $("#filter").val("");
            $("#filterCanceBtn").attr("style", "display:none");
        }
        m_JSON_REMOVE.splice(type, 1);
    }
    ArrayTraversal();
}

//删除按钮的样式
function DeleteBtn() {

    $(".sensitive>ul>li").hover(function () {
        $(this).find('i').show();
    }, function () {
        $(this).find('i').hide();
    });
    $(".sensitive-box").hover(function () {
        $(this).find('.i-close').show();
    }, function () {
        $(this).find('.i-close').hide();
    });
}

//提交
function Submit() {
    var item = { replace: m_JSON_REPLACE, remove: m_JSON_REMOVE };
    var strParaJson = $.toJSON({
        key: "keywordsreplace",
        param: item
    });
    $(".loading").show();
    $(".loadingcover").show();
    manageObj.parareset(strParaJson);
}
//提交回调
function AsyncParaResetResult(jsonResult) {
    if (jsonResult.success) {
        ShowMsg("myPageAlert", "提交成功！");
    } else {
        ShowError("myPageAlert", "提交失败！" + jsonResult.error);
    }
    $(".loadingcover").hide();
    $(".loading").hide();
}

//取消按钮
function CancelBtn(type) {
    m_Coordinate = -1;
    m_FilterWords = -1;
    if (type == 1) {
        $("#replaceBtn").text("添加");
        $("#replacefront").val("");
        $("#replaceafter").val("");
        $("#replaceCancelBtn").attr("style", "display:none");
    } else {
        $("#filterBtn").text("添加");
        $("#filter").val("");
        $("#filterCanceBtn").attr("style", "display:none");
    }
}